<?php
/* This functions.php template courtesy Noel Cower */
/* (http://www.noelcower.com) */

/* functions to make this all easier */

/*
 *   $id goes inside <li id="$id"> -- just in case you want a special
 *   sidebar or something.  Or you plan on using that fancy 'ajax'
 *   stuff.  $id is optional.
 *   $head is usually <h2>Your Title</h2> and any other info.  $head
 *   is optional, but it's recommended that you specify one.
 *
 *   To add a sidebar, call sp_sidebar_open( '', '<h2>Caption</h2>' )
 *   id and head are optional, but specifying head in specific is
 *   recommended for organizational purposes.
 *   Once the sidebar is open, simply render out content as normal,
 *   then call sp_sidebar_close( ) [or do a </div></li> -- whatever
 *   you prefer].
 */

$_sp_sidebar_is_open = false;
function sp_sidebar( $id='', $head='' )
{
    global $_sp_sidebar_is_open;
    if ( $_sp_sidebar_is_open )
        sp_sidebar_close( );
    else
        sp_sidebar_open( $id, $head );
}

// opens a sidebar with the id as $id and the header text as $head (<h2>/</h2> are not automatic)
function sp_sidebar_open( $id='', $head='' )
{
    global $_sp_sidebar_is_open;
    if ($_sp_sidebar_is_open)
        return;
    $_sp_sidebar_is_open = true;
    if ($id !== '')
        $id = " id=\"$id\"";
    echo "<li$id><div class=\"sidebar-head\">$head</div><div class=\"sidebar-content\">";

}

// closes a sidebar
function sp_sidebar_close( )
{
    global $_sp_sidebar_is_open;
    if (!$_sp_sidebar_is_open)
        return;
    $_sp_sidebar_is_open = false;
    echo "</div></li>";
}

// widget support
if ( function_exists( 'register_sidebar' ) )
{
    register_sidebar( array(
    'before_widget'=>'<li id="%1$s" class="%2$s">',
    'after_widget'=>'</div></li>',
    'before_title'=>'<div class="sidebar-head"><h2>',
    'after_title'=>'</h2></div><div class="sidebar-content">'
    ) );
    
    function sp_widget_search( $args )
    {
    	extract($args);
        echo $before_widget;
            echo $before_title;
                echo "Search";
            echo $after_title;
            ?>
			<form id="searchform" method="get" action="<?php bloginfo('home'); ?>">
			<div>
			<input type="text" name="s" id="s" size="21" /><br />
			<input type="submit" value="<?php _e('Search'); ?>" />
			</div>
			</form>
		<?php
        echo $after_widget;
    }

    register_sidebar_widget('Search', 'sp_widget_search');
} // widget support

// Renders the comment form.  Handy if you decide to move the comment form.
function sp_comment_form( )
{
    global $post, $user_ID, $user_identity;
    
    $url = get_option('siteurl');
    if (get_option('require_name_email'))
        $required = ' (required)';

    sp_entry_open( 'comments', '<a id="respond"></a><h2>Submit Comment</h2>' );

    if ( $post->comment_status == 'open' )
    {
        if ( get_option( 'comment_registration' ) && !$user_ID )
        {
            ?>
            <p>Sorry, but you have to <a href="<?php echo $url; ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">log in</a> to submit comments.</p>
            <?php
        }
        else
        {
            ?>
            <form action="<?php echo $url; ?>/wp-comments-post.php" method="post" id="commentform">
            <?php
            if ( $user_ID != 0 )
            {
                echo "<p>Logged in as <a href=\"$url/wp-admin/profile.php\">$user_identity</a>.</p>";
            }
            else
            {
                ?>
                <p><input id="author" name="author" type="text" value="<?php echo $comment_author; ?>" tabindex="1" size="24"/>
                <label for="author">Your name</label><?php echo $required; ?></p>
                <p><input id="email" name="email" type="text" value="<?php echo $comment_author_email; ?>" tabindex="2" size="24"/>
                <label for="email">Your e-mail</label><?php echo $required; ?> (This will <em>not</em> be published)</p>
                <p><input id="url" name="url" type="text" value="<?php echo $comment_author_url; ?>" tabindex="3" size="24"/>
                <label for="url">Your website</label></p>
                <?php
            }
            ?>
            <p><textarea id="comment" name="comment" cols="77%" rows="8" tabindex="4"></textarea></p>
            <p><?php do_action('comment_form', $post->ID); ?>
            <input type="submit" name="submit" id="submit" value="Submit"/>
            <input type="hidden" name="comment_post_ID" value="<?php the_ID(); ?>" /></p>
            </form>
            <?php
        }
    }
    else
    {
        ?>
        <p>Sorry, but commenting on this post is disabled.</p>
        <?php
    }

    sp_entry_close( '' );
}
?>